/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.ParameterItemValueComparator;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.Language;

public class PIDParameterset {
    public static final int INDEX_USER_DEFINED_SET = PIDParameterset.getList().length - 1;
    public static final String USER_DEFINED_NAME = "pid.paramset.udf";
    private static PIDParameterset[] cParamsets;
    private double fLoopGain;
    private TimeUnit fIntegralTime;
    private String fName;
    private boolean fPFunctionUsed;
    private boolean fIFunctionUsed;
    private boolean fDFunctionUsed;
    private char fDirection;

    private PIDParameterset(String s, double gain, TimeUnit integralTime, boolean IFunctionUsed, char direction) {
        this.fName = s;
        this.addGain(gain);
        this.addIntegralTime(integralTime);
        this.fIFunctionUsed = IFunctionUsed;
        this.fDirection = direction;
    }

    public static PIDParameterset[] getList() {
        if (cParamsets == null) {
            PIDParameterset.initialize();
        }
        return cParamsets;
    }

    private static void initialize() {
        cParamsets = new PIDParameterset[7];
        PIDParameterset.cParamsets[0] = new PIDParameterset("pid.paramset.tempFast", 0.5, new Minutes().setTime(30), true, '+');
        PIDParameterset.cParamsets[1] = new PIDParameterset("pid.paramset.tempSlow", 1.0, new Minutes().setTime(120), true, '+');
        PIDParameterset.cParamsets[2] = new PIDParameterset("pid.paramset.pressure1", 3.0, new Minutes().setTime(5), true, '+');
        PIDParameterset.cParamsets[3] = new PIDParameterset("pid.paramset.pressure2", 1.2, new Minutes().setTime(12), true, '+');
        PIDParameterset.cParamsets[4] = new PIDParameterset("pid.paramset.level1", 1.0, new Minutes().setTime(5999), true, '+');
        PIDParameterset.cParamsets[5] = new PIDParameterset("pid.paramset.level2", 0.7, new Minutes().setTime(20), true, '+');
        PIDParameterset.cParamsets[6] = new PIDParameterset(USER_DEFINED_NAME, 1.0, new Minutes().setTime(5999), false, '+');
    }

    private void addIntegralTime(TimeUnit integralTime) {
        this.fIntegralTime = integralTime;
    }

    private void addGain(double gain) {
        this.fLoopGain = gain;
    }

    public String toString() {
        String nameKey = this.getName();
        return Language.getString(nameKey, nameKey);
    }

    public String getName() {
        return this.fName;
    }

    public boolean isDFunctionUsed() {
        return this.fDFunctionUsed;
    }

    public boolean isIFunctionUsed() {
        return this.fIFunctionUsed;
    }

    public boolean isPFunctionUsed() {
        return this.fPFunctionUsed;
    }

    public double getLoopGain() {
        return this.fLoopGain;
    }

    public TimeUnit getIntegralTime() {
        return this.fIntegralTime;
    }

    public char getDirection() {
        return this.fDirection;
    }

    public static PIDParameterset getSet(double loopGain, TimeUnit integralTime, char direction) {
        PIDParameterset result = null;
        PIDParameterset[] list = PIDParameterset.getList();
        for (int i = 0; i < list.length; ++i) {
            PIDParameterset parameterset = list[i];
            if (parameterset.getLoopGain() != loopGain || !PIDParameterset.compareTimeUnit(parameterset.getIntegralTime(), integralTime) || parameterset.getDirection() != direction) continue;
            result = parameterset;
            break;
        }
        return result;
    }

    private static boolean compareTimeUnit(TimeUnit timeUnit1, TimeUnit timeUnit2) {
        try {
            return ParameterItemValueComparator.getInstance().compareTimeUnit(timeUnit1, timeUnit2);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getIndex() {
        for (int i = 0; i < cParamsets.length; ++i) {
            if (cParamsets[i] != this) continue;
            return i;
        }
        return -1;
    }
}

